//-------------------
// Benchmark Othello
// version WIN32 et POCKETPC
// Sylvain Huet
// Premiere version : 24/08/2002
// Derniere mise a jour : 26/08/2002

// Usage :
// lancer le programme, sans parametre


//Profondeur de recherche : valeur par dfaut 6
int DEPTH=6;

#include <stdio.h>
#include <string.h>
#include<sys/time.h>

#include "eval.h"
#include "alpha.h"


int maxdepth;
char tab[100];
int color;

int lastdelay;

int timeMs()
{
  struct timeval tm;
  int t;

  gettimeofday(&tm,NULL);
  t=(tm.tv_sec*1000)+(tm.tv_usec/1000);
  return t;
}

int initgame()
{
	int i,j;

	maxdepth=DEPTH;

	color=1;

	for (i=0;i<100;tab[i++]=3);

	for (j=10;j<90;j+=10)
		for (i=j+1;i<j+9;i++)
			tab[i]=0;

	tab[44]=-1;
	tab[45]=1;
	tab[54]=1;
	tab[55]=-1;

	lastdelay=0;
	return 0;
}
int drawboard(char* t)
{
  int i,j;
  for(i=1;i<=8;i++)
    {
      printf("%d|",i);
      for(j=1;j<=8;j++)
        printf("%c|",(t[i*10+j]>0)?'o':((t[i*10+j]<0)?'x':'_'));
      printf("\n");
    }
  printf("  1 2 3 4 5 6 7 8\n");
  printf("%d / %d - %d ms\n",pionsblancs(tab),pionsnoirs(tab),lastdelay);
  return 0;
}

int playcomputer()
{
	int coup;

	lastdelay=0;
	//	winupdate();
	do
	{
		if (doitpasser(tab,-color)) return 1;
		lastdelay=timeMs();
		coup=icib(tab,maxdepth,-color);
		lastdelay=timeMs()-lastdelay;
		if (coup>=0) valid(tab,coup,-color,1);
		drawboard(tab);
	}	while (doitpasser(tab,color));
	return 0;
}


// saisie d'un mouvement
int getmove()
{
  int m,k,res;

  do
    {
      res=0;
      printf("]");
      scanf("%d",&m);
      if ((m<10)||(m>88)) res=1;
      k=m%10;
      if ((k==0)||(k==9)) res=1;
    }
  while(res);
  return m;
}


int main(int argc,char** argv)
{
  int i,m;
  int n=0;
  int mode=2;
  int end=1;
  int round=0;

  printf("othello - by Sylvain Huet - 2008\n");
  printf("--------------------------------\n");
  i=0;
  while(i<argc)
  {
        if (!strcmp(argv[i],"-h"))
        {
                printf("usage : othello -l level -cc|-ch|-hc|-hh\n");
                return 0;
        }
        if ((!strcmp(argv[i],"-l"))&&(argc>i+1))
        {
                i++;
                DEPTH=atoi(argv[i]);
        }
        if (!strcmp(argv[i],"-cc")) mode=3;
        if (!strcmp(argv[i],"-ch")) mode=1;
        if (!strcmp(argv[i],"-hc")) mode=2;
        if (!strcmp(argv[i],"-hh")) mode=0;
        i++;
  }

  printf("level=%d\n",DEPTH);
  printf("player1=%s\n",(mode&1)?"computer":"human");
  printf("player2=%s\n",(mode&2)?"computer":"human");

  initgame();

  while(end)
    {
      printf("\n%d.\n",n++);
      drawboard(tab);
      if (doitpasser(tab,-color))
	{
	  if (doitpasser(tab,color)) end=0;
	  else printf("skip\n");
	}
      else
	{
	  if (mode&(1<<round))
	    {
	      lastdelay=timeMs();
	      m=icib(tab,maxdepth,-color);
	      lastdelay=timeMs()-lastdelay;
	      valid(tab,m,-color,1);
	    }
	  else
	    {
	      lastdelay=-1;
	      do
		{
		  m=getmove();
		}
	      while (!valid(tab,m,-color,1));
	    }
	}
      round=1-round;
      color=-color;
    }
  return 0;
}



