/*
                    TTTTTTT    OOOOO    7777777
                       T      O     O        7
                       T      O     O       7
                       T      O     O      7
                       T      O     O     7
                       T       OOOOO     7

                             EMULATEUR

                          Par Sylvain HUET
                    (huet@poly.polytechnique.fr)
                               1994

  video.c : routines video de l'emulateur (+gestion memoire)

*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/keysym.h>

#include "monitor.h"
#include "emuto7.h"

#define nbtouche 68

int		black,white;
char		*nomstat=NULL;
Display		*display;
int		screen;
Colormap	cmap;
Visual		*visual;
Window		root,win;
GC		gc,mygc[256];
short		imac[400],codedb[256];
XImage		*ima;
XColor		tCol,tCol_exact;
static char	*nom[16]=
{"gray","pink","pale green","light yellow","light slate blue","violet"
,"light cyan","orange"
,"black","red","green","yellow","blue","magenta","cyan","white"};
static char	*nommono[16]=
{ "black","gray15","gray30","gray45","gray60","gray75","gray90","white"
,"black","gray15","gray30","gray45","gray60","gray75","gray90","white"};
int		col[16];

char		modif[1040];
int		conv[8192];

int	tch[2];
int	lkey[256];
int	ckey[256];
FILE	*fl;
FILE	*fk7;
int	crayx,crayy;
int	lasttour;

int nbwait;

int	codel[]=
{0x01,0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x04,0x08,0x10,0x20,0x40,0x80
,0x04,0x08,0x10,0x20,0x40,0x80,0x80,0x40,0x20,0x10
,0x04,0x08,0x10,0x20,0x40,0x80,0x80,0x40,0x20,0x10
,0x04,0x08,0x10,0x20,0x40,0x80,0x80,0x40,0x20,0x10
,0x02,0x04,0x02,0x04,0x08,0x80
,0x04,0x08,0x04,0x08,0x10,0x20,0x40,0x08
,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00
};
int	codec[]=
{0x01,0x01,0x80,0x40,0x20,0x10,0x08,0x02,0x02,0x02,0x02,0x02,0x02,0x02
,0x80,0x80,0x80,0x80,0x80,0x80,0x40,0x40,0x40,0x40
,0x20,0x20,0x20,0x20,0x20,0x20,0x10,0x10,0x10,0x10
,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x04,0x04
,0x01,0x01,0x04,0x04,0x04,0x01
,0x40,0x40,0x10,0x10,0x01,0x01,0x01,0x01
,0xfe,0xfb,0xfd,0xf7,0x1
,0xef,0xbf,0xdf,0x7f,0x2
};

void inicray()
	{

	crayx=-1;
	}

void inikey(char *name)
	{
		int	i,key;

	for(i=0;i<256;i++)
		{
		lkey[i]=0;
		ckey[i]=255;
		}
	tch[0]=tch[1]=0;

	if (fl=fopen(name,"r"))
		{
		for(i=0;i<nbtouche;i++)
			{
			fscanf(fl,"%d",&key);
			lkey[key&255]=codel[i];
			ckey[key&255]=(~codec[i])&255;
			}
		fclose(fl);
		}
		else
		{
		printf("lancer d'abord enterkey\n");
		exit(0);
		}
	buf[0xe7cc]=0;
	buf[0xe7cd]=0;
	buf[0xe7ce]=0;
	buf[0xe7cf]=0;
	}

void newcass(char *c)
	{
	if (fk7) fclose(fk7);
	if ((fk7=fopen(c,"r+"))==NULL) fk7=fopen(c,"w+");
	if (fk7==NULL) if (fk7=fopen(c,"r")) printf("LECTURE SEULE\n");
	if (fk7==NULL) printf("impossible\n");
		else
		printf("cassette %s\n",c);
	}

void avanck7(long k)
	{
	if (fk7==NULL)
		printf("impossible\n");
		else
		{
		fseek(fk7,k,0);
		printhx(ftell(fk7),4);
		printf(" : nouvelle position\n");
		}
	}

void inik7()
	{
	fk7=NULL;
	}

void iniscreen(char *name)
	{
		int	i,j,k,l,n;
		XGCValues xgc;
	display=XOpenDisplay(nomstat);
	screen=DefaultScreen(display);
	visual=DefaultVisual(display,screen);
	cmap=DefaultColormap(display,screen);
	root=RootWindow(display,screen);
	black=BlackPixel(display,screen);
	white=WhitePixel(display,screen);
	gc=DefaultGC(display,screen);

	if(modegraph==0)
	{
	for(i=0;i<256;i++)
		{
		mygc[i]=XCreateGC(display,root,0,&xgc);
		XSetForeground(display,mygc[i],white);
		XSetBackground(display,mygc[i],black);
		}
	}
	if(modegraph==1)
	{
	for (i=0;i<16;i++)
		{
		XAllocNamedColor(display,cmap,nom[i],&tCol,&tCol_exact);
		col[i]=tCol.pixel;
		}

	for(k=0;k<2;k++)
	for(l=0;l<2;l++)
	for(i=0;i<8;i++)
	for(j=0;j<8;j++)
		{
		mygc[128*l+64*k+8*i+j]=XCreateGC(display,root,0,&xgc);
		XSetForeground(display,mygc[128*l+64*k+8*i+j],col[k*8+i]);
		XSetBackground(display,mygc[128*l+64*k+8*i+j],col[l*8+j]);
		}
	}
	if(modegraph==2)
	{
	printf("a\n");
	for (i=0;i<16;i++)
		{
		XAllocNamedColor(display,cmap,nommono[i],&tCol,&tCol_exact);
		col[i]=tCol.pixel;
		}

	printf("b\n");
	for(k=0;k<2;k++)
	for(l=0;l<2;l++)
	for(i=0;i<8;i++)
	for(j=0;j<8;j++)
		{
		mygc[128*l+64*k+8*i+j]=XCreateGC(display,root,0,&xgc);
		XSetForeground(display,mygc[128*l+64*k+8*i+j],col[k*8+i]);
		XSetBackground(display,mygc[128*l+64*k+8*i+j],col[l*8+j]);
		}
	}

	win=XCreateSimpleWindow(display, root,0,0,680,440,1,white,black);
	XSetStandardProperties(display, win, "To7","To7",0,
		NULL,0,NULL);
	XSetWindowColormap(display,win,cmap);
	XSelectInput(display,win,ExposureMask|ButtonPressMask|ButtonReleaseMask
			|Button2MotionMask|KeyPressMask|KeyReleaseMask);
	XMapWindow(display,win);
	
	ima=XCreateImage(display,visual,
		1,XYBitmap,0,(char *) imac,16,16*25,16,2);
	for(i=0;i<256;i++)
		{
		for (j=7,n=i;j>=0;j--,n>>=1)
			{
			XPutPixel(ima,j*2,0,n&1);
			XPutPixel(ima,j*2+1,0,n&1);
			}
		codedb[i]=imac[0];
		}
	XFlush(display);

	for(i=0;i<8192;i++) conv[i]=(i%40)*25+(i/320);
	inikey(name);
	inicray();
	inik7();
	lasttour=0;
	}

void refreshv()
	{
		char	*fr;
		char	*fd;
		char	*p;
		char	*q;
		int	x,y;
		int	j;
		int	cl;
		char	*tes;

	fr=&buf[0x4000];
	fd=&buf[0x10000];
	tes=modif;
	for(x=0;x<640;x+=16)
		{
		j=0;
		cl=*fd;
		p=fr;
		q=fd;
		for(y=0;y<400;y+=2)
			{
			if (!(y&15))
			  {
			  if (*tes)	*(tes++)=0;
			  else	{
				if (y-j)	XPutImage(display,win
				   ,mygc[(cl&255)],ima,0,0,x+20,j+20,16,y-j);
				y+=14;
				p+=320;
				q+=320;
				cl=*q;
				j=y+2;
				tes++;
				continue;
				}	
			  }
			if ((*q)!=cl)
					{
					XPutImage(display,win,mygc[(cl&255)]
						,ima,0,0,x+20,j+20,16,y-j);
					j=y;
					cl=*q;
					}
			imac[y-j]=imac[y+1-j]=codedb[((*p)&255)];
			p+=40;
			q+=40;

			}
		if(y-j)	XPutImage(display,win
				,mygc[(cl&255)],ima,0,0,x+20,j+20,16,y-j);
		fr+=1;
		fd+=1;
		}
	if ((modegraph)&&(lasttour!=(buf[0xe7c3]&0x70)))
		{
		lasttour=(buf[0xe7c3]&0x70);
		cl=(lasttour>>1)+0x40;
		XFillRectangle(display,win,mygc[cl],0,0,680,20);
		XFillRectangle(display,win,mygc[cl],0,20,20,400);
		XFillRectangle(display,win,mygc[cl],660,20,20,400);
		XFillRectangle(display,win,mygc[cl],0,420,680,20);
		}
	XFlush(display);
	}

void refreshsc()
	{
		int	i;

	for(i=0;i<1000;i++)	modif[i]=1;
	lasttour=0;
	refreshv();
	}

void effacewin(int i, long xm, long xx)
	{
	if(modegraph) XFillRectangle(display,win
			,mygc[i],20,20+xm*2,640,(xx-xm)*2);
	else	{
		XSetForeground(display,gc,black);
		XFillRectangle(display,win
			,gc,20,20+xm*2,640,(xx-xm)*2);
		XSetForeground(display,gc,white);
		}
	}

void scrollhaut(int cl, long xm, long xx, int i, int fl)
	{
	XCopyArea(display,win,win,gc,20,20+(xm+i)*2,640,(xx-xm-i)*2,20,20+xm*2);
	if (fl)
		{
		if (modegraph)
		XFillRectangle(display,win,mygc[cl],20,20+(xx-i)*2,640,i*2);
		else
		{
		XSetForeground(display,gc,black);
		XFillRectangle(display,win,gc,20,20+(xx-i)*2,640,i*2);
		XSetForeground(display,gc,white);
		}	
		}
	}

void scrollbas(int cl, long xm, long xx, int i, int fl)
	{
	XCopyArea(display,win,win,gc,20,20+xm*2,640,(xx-xm-i)*2,20,20+(xm+i)*2);
	if (fl) {
		if (modegraph)
		XFillRectangle(display,win,mygc[cl],20,20+xm*2,640,i*2);
		else
		{
		XSetForeground(display,gc,black);
		XFillRectangle(display,win,gc,20,20+xm*2,640,i*2);
		XSetForeground(display,gc,white);
		}	
		}
	}

long loads(long k)
	{
	if ((k&0xe000)==0x4000)
		{
		if (!(buf[0xe7c3]&1)) k+=0xc000;
		}
		else
		{
		if ((k&0xffc0)==0xe7C0)
			{		/* gestion des io	*/
			if (k==0xe7c8)	/* lecture clavier */
				{
					int pb=~buf[0xe7c9];
				return (0xff
					&((pb&lkey[tch[0]])?ckey[tch[0]]:0xff)
					&((pb&lkey[tch[1]])?ckey[tch[1]]:0xff));
				}
			if (k==0xe7c0) return 0x81;
			if (k>0xe7d0)	{
					printhx(pc,8);
					printf("\n");
					}
			return buf[k]&255;
			}
		}
	return buf[k]&255;
	}

long loadl(long k)
	{
	if ((k&0xe000)==0x4000)
		{
		if (!(buf[0xe7c3]&1)) k+=0xc000;
		}
		else
		{
		if ((k&0xffc0)==0xe7C0)
			{		/* gestion des io	*/
			return loads(k)<<8+loads(k+1);
			}
		}
	return ((buf[k]&255)<<8)+(buf[k+1]&255);
	}

int stocs(long k,long val)
	{
	if (k<0x6000)
		{
		if (k<0x4000) return 0;
		modif[conv[k-0x4000]]=1;
		if (!(buf[0xe7c3]&1))
				{
				k+=0xc000;
				if ((pc>endmem)||(flto7)) val|=mask;
				}
		buf[k]=val;
		return 0;
		}
		else
		{
		if (k>endmem)
			{
			if ((k<0xe7c0)||(k>0xe7cb)) return 0;
			}
		}
	buf[k]=val;
	}

int stocl(long k,long val)
	{
	if (k<0x6000)
		{
		if (k<0x4000) return 0;
		modif[conv[k-0x4000]]=1;
		modif[conv[k+1-0x4000]]=1;
		if (!(buf[0xe7c3]&1))
				{
				k+=0xc000;
				if ((pc>endmem)||(flto7)) val|=mask;
				}
		buf[k+1]=val;
		val>>=8;
		buf[k]=val;
		return 0;
		}
		else
		{
		if (k>endmem)
			{
			if ((k<0xe7c0)||(k>0xe7cb)) return 0;
			}
		}
	buf[k+1]=val;
	val>>=8;
	buf[k]=val;
	}

long	compt;
int	quitf;

void bouclex()
	{
		XEvent	ev;
		int	i,j,k;
		int	key;
	j=0;
	compt=0;
	tch[0]=tch[1]=0;
	quitf=1;
	while(quitf)
	{
	for(i=0;i<20000;i++)
          {
	    exe6809();
            for(k=0;k<nbwait;k++);
          }

	if ((++j)==3)
		{
		if (!(ccrest&0x10))
			{
			ccrest|=0x80;
			pshsr(0xff);
			ccrest|=0x10;
			pc=((buf[0xfff8]<<8)+(buf[0xfff9]&255))&0xffff;
			}
		j=0;
		}
	refreshv();
	while(XEventsQueued(display,QueuedAfterFlush))
		{
		XNextEvent(display,&ev);
		switch(ev.type)	{
		case Expose:
			while(XCheckTypedEvent(display,Expose,&ev));
			refreshsc();
			break;
		case ButtonPress:
			switch(ev.xbutton.button) {
			case 2:
				crayx=(ev.xbutton.x-20)/2;
				crayy=(ev.xbutton.y-20)/2;
				break;
			case 1:
				buf[0xe7c3]|=2;
				break;
			case 3:
				quitf=0;
				break;
			default:
				break;	}
			break;
		case MotionNotify:
			crayx=(ev.xbutton.x-20)/2;
			crayy=(ev.xbutton.y-20)/2;
			break;
		case ButtonRelease:
			switch(ev.xbutton.button) {
			case 2:
				crayx=-1;
				break;
			case 1:
				buf[0xe7c3]&=0xfd;
				break;
			default:
				break;	}
			break;
		case KeyPress:
			key=ev.xkey.keycode&255;
			if (lkey[key])
				{
				if (tch[0]==0) tch[0]=key;
					else if (tch[0]!=key) tch[1]=key;
				}
			else	if ((i=ckey[key])!=255)
				{
				if (i==0xfe) 	{
						buf[0xe7cd]&=0xbf;
						buf[0xe7ce]&=0x7f;
						}
				if (i==0xfd) 	{
						buf[0xe7cd]&=0x7f;
						buf[0xe7cf]&=0x7f;
						}
				if (i<0xfd)	buf[0xe7cc]&=~i;
				}
			break;
		case KeyRelease:
			key=ev.xkey.keycode&255;
			if (lkey[key])
				{
				if (tch[0]==key)
						{
						tch[0]=tch[1];
						tch[1]=0;
						}
				if (tch[1]==key) tch[1]=0;
				}
			else	if ((i=ckey[key])!=255)
				{
				if (i<0xfd)	buf[0xe7cc]|=i;
				if (i==0xfe) 	{
						buf[0xe7cd]|=0x40;
						buf[0xe7ce]|=0x80;
						}
				if (i==0xfd) 	{
						buf[0xe7cd]|=0x80;
						buf[0xe7cf]|=0x80;
						}
				}
			break;
		default :
			break;	}
		}
	}
	}

