/* routines de gestion de repertoire*/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>

#include "config.h"

#if DECALPHA
#include <dirent.h>
#endif

void fillspace(char *name, int size)
{
  int i;
  
  for(i=strlen(name);i<size;i++) putchar(' ');
} 


void displaydir()
{
  DIR *d;

#if DECALPHA
  struct dirent *dp;
#else
  struct direct *dp;
#endif
  struct stat buf;
  char nam[256];

  if (d=opendir("."))
    {
      while((dp=readdir(d))!=NULL)
	{
	  strcpy(nam,"./");
	  strcat(nam,dp->d_name);
	  stat(nam,&buf);
	  if ((buf.st_mode&S_IFMT)==S_IFDIR)
	    {
	      fillspace(dp->d_name,14);
	      printf("<%s>",dp->d_name);
	    }
	}
      printf("\n");
      seekdir(d,0);
      while((dp=readdir(d))!=NULL)
	{
	  strcpy(nam,"./");
	  strcat(nam,dp->d_name);
	  stat(nam,&buf);
	  if ((buf.st_mode&S_IFMT)!=S_IFDIR)
	    {
	      fillspace(dp->d_name,16);
	      printf("%s",dp->d_name);
	    }
	}
      printf("\n");
    }
}


void changedir(char *path)
{
  chdir(path);
} 

void displaypath()
{
  char name[256];
  
  getcwd(name,256);
  printf("%s\n",name);
}


