/*
                    TTTTTTT    OOOOO    7777777
                       T      O     O        7
                       T      O     O       7
                       T      O     O      7
                       T      O     O     7
                       T       OOOOO     7

                             EMULATEUR

                          Par Sylvain HUET
                    (huet@poly.polytechnique.fr)
                               1994

  emuto7.c : emulateur 6809. adressage

*/

#include "monitor.h"
#include "emuto7.h"
#include "video.h"

long	pc;
long	xr,yr,ur,sr;
long	ar,br;
long	dp;

long	mask;
int	flto7;
long	endmem;

int	res,m1,m2,sign,ovfl,h1,h2,ccrest;

char	*op;
int	ad;
long*	(regist[4]);
long*	(exreg[16]);

void inito7(char *name)
	{
		int	i;

	xr=yr=yr=0;
	pc=0xef26;
	sr=0x8000;
	ar=br=0;
	dp=0;
	res=m1=m2=sign=ovfl=ccrest=0;
	regist[0]=&xr;
	regist[1]=&yr;
	regist[2]=&ur;
	regist[3]=&sr;
	for(i=0;i<16;i++) exreg[i]=NULL;
	exreg[1]=&xr;
	exreg[2]=&yr;
	exreg[3]=&ur;
	exreg[4]=&sr;
	exreg[5]=&pc;
	exreg[8]=&ar;
	exreg[9]=&br;
	exreg[11]=&dp;
	mask=0xc0c0;
	iniscreen(name);
	}

long getcc()
	{
	return	((((h1&15)+(h2&15))&16)<<1)
		|((sign&0x80)>>4)
		|((((res&0xff)==0)&1)<<2)
		|(( ((~(m1^m2))&(m1^ovfl)) &0x80)>>6)
		|((res&0x100)>>8)
		|ccrest;
	}

void setcc(int i)
	{
	m1=m2=0;
	res=((i&1)<<8)|(4-(i&4));
	ovfl=(i&2)<<6;
	sign=(i&8)<<4;
	h1=h2=(i&32)>>2;
	ccrest=i&0xd0;
	}

long direc()
	{
	return (dp<<8)+((*op)&255);
	}

long inher()
	{
	return -1;
	}

long immedc()
	{
	return (pc-1)&0xffff;
	}

long immedl()
	{
	return (pc-2)&0xffff;
	}

long indxp()
	{
		long	*x=regist[((*op)&0x60)>>5];
		long	k;
	k=*x;
	*x=((*x)+1)&0xffff;
	return k;
	}

long indxpp()
	{
		long	*x=regist[((*op)&0x60)>>5];
		long	k;
	k=*x;
	*x=((*x)+2)&0xffff;
	return k;
	}

long indmx()
	{
		long	*x=regist[((*op)&0x60)>>5];
	*x=((*x)-1)&0xffff;
	return *x;
	}

long indmmx()
	{
		long	*x=regist[((*op)&0x60)>>5];
	*x=((*x)-2)&0xffff;
	return *x;
	}

long indx()
	{
	return *(regist[((*op)&0x60)>>5]);
	}

long indax()
	{
		char	a=ar;
	return ((*(regist[((*op)&0x60)>>5]))+a)&0xffff;
	}

long indbx()
	{
		char	b=br;
	return ((*(regist[((*op)&0x60)>>5]))+b)&0xffff;
	}

long inder()
	{
	return 0;
	}	

long ind1x()
	{
		char	del=op[1];
	pc++; pc&=0xffff;
	return ((*(regist[((*op)&0x60)>>5]))+del)&0xffff;
	}

long ind2x()
	{
		int	del=((op[1]&255)<<8)+(op[2]&255);
	pc+=2; pc&=0xffff;
	return ((*(regist[((*op)&0x60)>>5]))+del)&0xffff;
	}

long inddx()
	{
		int	del=(ar<<8)+br;
	return ((*(regist[((*op)&0x60)>>5]))+del)&0xffff;
	}

long ind1p()
	{
		char	del=op[1];

	pc++; pc&=0xffff;
	return (pc+del)&0xffff;
	}

long ind2p()
	{
		int	del=((op[1]&255)<<8)+(op[2]&255);
	pc+=2; pc&=0xffff;
	return (pc+del)&0xffff;
	}

long indad()
	{
	pc+=2; pc&=0xffff;
	return ((op[1]&255)<<8)+(op[2]&255);
	}

long (*indmod[])()=
{indxp,indxpp,indmx,indmmx,indx,indbx,indax,inder
,ind1x,ind2x,inder,inddx,ind1p,ind2p,inder,indad
};

long indir()
	{
		long	k;

	if ((*op)&0x80)
		{
		k=(*indmod[(*op)&15])();
		if ((*op)&0x10) return ((buf[k]&255)<<8)+(buf[k+1]&255);
		return k;
		}
	if ((*op)&0x10)	return (*(regist[((*op)&0x60)>>5]))-((-*op)&15);
	return (*(regist[((*op)&0x60)>>5]))+((*op)&15);
	}

long etend()
	{
	return (((*op)&255)<<8)+(op[1]&255);
	}

long (*adresc[])()=
{direc,inher,inher,immedc,indir,etend,inher};

long (*adresl[])()=
{direc,inher,inher,immedl,indir,etend,inher};

void what()
	{
/*	printhx(pc,8);
	printf(" erreur\n");
*/
	}

void cd10();
void cd11();

void (*code[])()=
{negm,iosb,what,comm,lsrm,what,rorm,asrm,aslm,rolm,decm,what,incm,tstm,jmpm,clrm
,cd10,cd11,nopm,synm,what,what,lbra,lbsr,what,daam,orcc,what,andc,sexm,exgm,tfrm
,bras,brns,bhis,blss,bccs,blos,bnes,beqs,bvcs,bvss,bpls,bmis,bges,blts,bgts,bles
,leax,leay,leas,leau,pshs,puls,pshu,pulu,what,rtsm,abxm,rtim,cwai,mulm,what,swim
,nega,what,what,coma,lsra,what,rora,asra,asla,rola,deca,what,inca,tsta,what,clra
,negb,what,what,comb,lsrb,what,rorb,asrb,aslb,rolb,decb,what,incb,tstb,what,clrb
,negm,what,what,comm,lsrm,what,rorm,asrm,aslm,rolm,decm,what,incm,tstm,jmpm,clrm
,negm,what,what,comm,lsrm,what,rorm,asrm,aslm,rolm,decm,what,incm,tstm,jmpm,clrm
,suba,cmpa,sbca,subd,anda,bita,ldam,what,eora,adca,oram,adda,cmpx,bsrm,ldxm,what
,suba,cmpa,sbca,subd,anda,bita,ldam,stam,eora,adca,oram,adda,cmpx,jsrm,ldxm,stxm
,suba,cmpa,sbca,subd,anda,bita,ldam,stam,eora,adca,oram,adda,cmpx,jsrm,ldxm,stxm
,suba,cmpa,sbca,subd,anda,bita,ldam,stam,eora,adca,oram,adda,cmpx,jsrm,ldxm,stxm
,subb,cmpb,sbcb,addd,andb,bitb,ldbm,what,eorb,adcb,orbm,addb,lddm,what,ldum,what
,subb,cmpb,sbcb,addd,andb,bitb,ldbm,stbm,eorb,adcb,orbm,addb,lddm,stdm,ldum,stum
,subb,cmpb,sbcb,addd,andb,bitb,ldbm,stbm,eorb,adcb,orbm,addb,lddm,stdm,ldum,stum
,subb,cmpb,sbcb,addd,andb,bitb,ldbm,stbm,eorb,adcb,orbm,addb,lddm,stdm,ldum,stum

,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,lbrn,lbhi,lbls,lbcc,lblo,lbne,lbeq,lbvc,lbvs,lbpl,lbmi,lbge,lblt,lbgt,lble
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,swi2
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,cmpd,what,what,what,what,what,what,what,what,cmpy,what,ldym,what
,what,what,what,cmpd,what,what,what,what,what,what,what,what,cmpy,what,ldym,stym
,what,what,what,cmpd,what,what,what,what,what,what,what,what,cmpy,what,ldym,stym
,what,what,what,cmpd,what,what,what,what,what,what,what,what,cmpy,what,ldym,stym
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,ldsm,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,ldsm,stsm
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,ldsm,stsm
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,ldsm,stsm

,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,swi3
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,cmpu,what,what,what,what,what,what,what,what,cmps,what,what,what
,what,what,what,cmpu,what,what,what,what,what,what,what,what,cmps,what,what,what
,what,what,what,cmpu,what,what,what,what,what,what,what,what,cmps,what,what,what
,what,what,what,cmpu,what,what,what,what,what,what,what,what,cmps,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what,what
,what,what,what,cmpu,what,what,what,what,what,what,what,what,cmps,what,what,what
};

void cd10()
	{
		int	r;
	
	op=&buf[pc+1];
	r=((*(op++))&255)+256;
	ad=adr[r];
	pc+=taille[r];
	(*(code[r]))();
	}

void cd11()
	{
		int	r;
	
	op=&buf[pc+1];
	r=((*(op++))&255)+512;
	ad=adr[r];
	pc+=taille[r];
	(*(code[r]))();
	}

long exe6809()
	{
		int	r;
	
	op=&buf[pc];
	r=(*(op++))&255;
	ad=adr[r];
	pc+=taille[r];
	(*(code[r]))();
	
	return pc;
	}

void printreg()
	{
	printf(" PC    A   B    X     Y     U     S   DP  CC\n");
	printhx(pc,4); printf("  ");
	printhx(ar,2); printf("  ");
	printhx(br,2); printf("  ");
	printhx(xr,4); printf("  ");
	printhx(yr,4); printf("  ");
	printhx(ur,4); printf("  ");
	printhx(sr,4); printf("  ");
	printhx(dp,2); printf("  ");
	printhx(getcc(),2); printf("  ");
	printf("\n");
	}

void printind()
	{
	printf(" m1    m2    res  sign  ovfl   h1    h2\n");
	printhx(m1,4); printf("  ");
	printhx(m2,4); printf("  ");
	printhx(res,4); printf("  ");
	printhx(sign,4); printf("  ");
	printhx(ovfl,4); printf("  ");
	printhx(h1,4); printf("  ");
	printhx(h2,4); printf("  ");
	printf("\n");
	}

void setreg(char *c,long k)
	{
	if (!strcmp(c,"pc")) pc=k&0xffff;
	if (!strcmp(c,"a")) ar=k&0xff;
	if (!strcmp(c,"b")) br=k&0xff;
	if (!strcmp(c,"x")) xr=k&0xffff;
	if (!strcmp(c,"y")) yr=k&0xffff;
	if (!strcmp(c,"u")) ur=k&0xffff;
	if (!strcmp(c,"s")) sr=k&0xffff;
	if (!strcmp(c,"dp")) dp=k&0xff;
	if (!strcmp(c,"cc")) setcc(k);
	}
