/*
                    TTTTTTT    OOOOO    7777777
                       T      O     O        7
                       T      O     O       7
                       T      O     O      7
                       T      O     O     7
                       T       OOOOO     7

                             EMULATEUR

                          Par Sylvain HUET
                    (huet@poly.polytechnique.fr)
                               1994

  emup3.c : emulateur 6809. 3eme partie

*/

#include "monitor.h"
#include "emuto7.h"

void lbrn()
	{
	}

void lbhi()	/* c|z=0 */
	{
	if ((!(res&0x100))&&(res&0xff)) pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}
void lbls()	/* c|z=1 */
	{
	if ((res&0x100)||(!(res&0xff))) pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}

void lbcc()	/* c=0 */
	{
	if (!(res&0x100)) pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}
void lblo()	/* c=1 */
	{
	if (res&0x100) pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}

void lbne()	/* z=0 */
	{
	if (res&0xff) pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}
void lbeq()	/* z=1 */
	{
	if (!(res&0xff)) pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}

void lbvc()	/* v=0 */
	{
	if ( ((m1^m2)&0x80)||(!((m1^ovfl)&0x80)) )
			pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}
void lbvs()	/* v=1 */
	{
	if ( (!((m1^m2)&0x80))&&((m1^ovfl)&0x80) )
			pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}

void lbpl()	/* n=0 */
	{
	if (!(sign&0x80)) pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}
void lbmi()	/* n=1 */
	{
	if (sign&0x80) pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}

void lbge()	/* n^v=0 */
	{
	if (!((sign^((~(m1^m2))&(m1^ovfl)))&0x80))
			pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}
void lblt()	/* n^v=1 */
	{
	if ((sign^((~(m1^m2))&(m1^ovfl)))&0x80)
			pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}

void lbgt()	/* z|(n^v)=0 */
	{
	if ( (res&0xff)
	   &&(!((sign^((~(m1^m2))&(m1^ovfl)))&0x80)) )
			pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}
void lble()	/* z|(n^v)=1 */
	{
	if ( (!(res&0xff))
	   ||((sign^((~(m1^m2))&(m1^ovfl)))&0x80) )
			pc=(pc+(op[0]<<8)+(op[1]&255))&0xffff;
	}

void swi2()
	{
	ccrest|=0x80;
	pshsr(0xff);
	pc=((buf[0xfff4]<<8)+(buf[0xfff5]&255))&0xffff;
	}

void swi3()
	{
	ccrest|=0x80;
	pshsr(0xff);
	pc=((buf[0xfff2]<<8)+(buf[0xfff3]&255))&0xffff;
	}

void cmpd()		/* NxZxVxCx */
	{
		long	dr,val;
	val=loadl((*adresl[ad])());
	m1=ar; m2=(-val)>>8;
	dr=(ar<<8)+br-val;
	ovfl=res=sign=dr>>8;
	res|=(dr&255);
	}

void cmpy()		/* NxZxVxCx */
	{
		long	val;
	val=loadl((*adresl[ad])());
	m1=yr>>8; m2=(-val)>>8;
	ovfl=res=sign=(yr-val)>>8;
	res|=(yr-val)&255;
	}

void cmpu()		/* NxZxVxCx */
	{
		long	val;
	val=loadl((*adresl[ad])());
	m1=ur>>8; m2=(-val)>>8;
	ovfl=res=sign=(ur-val)>>8;
	res|=(ur-val)&255;
	}

void cmps()		/* NxZxVxCx */
	{
		long	val;
	val=loadl((*adresl[ad])());
	m1=sr>>8; m2=(-val)>>8;
	ovfl=res=sign=(sr-val)>>8;
	res|=(sr-val)&255;
	}

void ldym()	/* NxZxV0 */
	{
	yr=loadl((*adresl[ad])());
	m1=ovfl;
	sign=yr>>8;
	res=(res&0x100)|((sign|yr)&255);
	}

void stym()		/* NxZxV0 */
	{
	stocl((*adresl[ad])(),yr);
	m1=ovfl;
	sign=yr>>8;
	res=(res&0x100)|((sign|yr)&255);
	}

void ldsm()	/* NxZxV0 */
	{
	sr=loadl((*adresl[ad])());
	m1=ovfl;
	sign=sr>>8;
	res=(res&0x100)|((sign|sr)&255);
	}

void stsm()		/* NxZxV0 */
	{
	stocl((*adresl[ad])(),sr);
	m1=ovfl;
	sign=sr>>8;
	res=(res&0x100)|((sign|sr)&255);
	}

